/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package producerconsumer;

/**
 *
 * @author fv
 */
public class PrimesProducer extends Thread {

    private boolean[] isPrime;
    private Queue stack;

    public PrimesProducer(Queue stack) {
        this.stack = stack;
    }

    public void findPrimes(int max) {
        isPrime = new boolean[max + 1];
        int squareRoot = (int) (Math.sqrt(max) + 1);

        isPrime[0] = false;
        isPrime[1] = false;
        for (int i = 2; i <= max; i++) {
            isPrime[i] = true;
        }

        int i = 2;
        int j;
        while (i < squareRoot) {
            if (isPrime[i]) {
                j = i * 2;
                while (j <= max) {
                    isPrime[j] = false;
                    j += i;
                }
            }
            i++;
        }
    }
    
    @Override
    public void run() {
        for (int i = 0; i < isPrime.length; i++) {
            if (isPrime[i]) {
                stack.put(i);
            }
        }
    }
}
